//	CDialogInsertDisk.c

#include "string.h"
#include "stdio.h"
#include "Utils.h"
#include "MainEvent.h"

#include "CDialogInsertDisk.h"

typedef struct {
	Dlog_ItemIDType			i_itemHit;
	Boolean					i_doneB;
} Dlog_DeleteFileRec;

static	Dlog_DeleteFileRec		S_insertAnswer;

void				ResetInsertDiskDialog(Dlog_ItemIDType itemID)
{
	S_insertAnswer.i_itemHit	= itemID;
	S_insertAnswer.i_doneB		= itemID != kDlog_InsertDisk_ItemID_NONE;
}

static	Boolean		InsertDisk_S_CB(short buttonID, void *cbData)
{
	Dlog_DeleteFileRec		*deleteAnswerP = (Dlog_DeleteFileRec *)cbData;
	
	deleteAnswerP->i_itemHit	= buttonID;
	deleteAnswerP->i_doneB		= TRUE;
	
	return TRUE;
}

#define		kDriveNumShiftBits		4
Boolean		IsInsertDiskDialogUp(short driveNumS)
{
	Boolean	isUpB = gCDialog3Button != NULL 
		&& gCDialog3Button->i_paramRec.DoneCB == InsertDisk_S_CB;
	
	if (isUpB) {
		HideWindow(gCDialog3Button->GetWindowRef());
		
		if ((*gCDialog3Button->i_paramRec.DoneCB)(
			driveNumS << kDriveNumShiftBits, gCDialog3Button->i_paramRec.cbData)
		) {
			gCDialog3Button->Dispose();
		} else {
			ShowWindow(gCDialog3Button->GetWindowRef());
		}
	}
	
	return isUpB;
}

//	returns driveNumber
short		DoInsertDiskDialog(short driveNumS)
{
	CDialog3Button			*dialogP;
	Dlog3ButtonParamRec		dialogParams;
	Dlog3ButtonRec			*buttonP;
	
	strcpy(dialogParams.titleAC, "Insert Disk");
	
	sprintf(
		dialogParams.verbageAC, 
		"Please insert a floppy disk into drive %d.", (int)driveNumS);
	
	dialogParams.DoneCB = InsertDisk_S_CB;
	dialogParams.cbData	= &S_insertAnswer;

	buttonP = &dialogParams.buttonA[kDlog_InsertDisk_ItemID_INSERTED_1];
	strcpy(buttonP->nameAC, "");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_1;
	buttonP->actionType		= Dlog_Action_NONE;
	buttonP->visibleB		= FALSE;
	buttonP->keyEquivChar	= 0;

	buttonP = &dialogParams.buttonA[kDlog_InsertDisk_ItemID_INSERTED_2];
	strcpy(buttonP->nameAC, "");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_2;
	buttonP->actionType		= Dlog_Action_NONE;
	buttonP->visibleB		= FALSE;
	buttonP->keyEquivChar	= 0;

	buttonP = &dialogParams.buttonA[kDlog_InsertDisk_ItemID_CANCEL];
	strcpy(buttonP->nameAC, "Cancel");
	buttonP->buttonID		= kDlog_3Button_ItemStr_BUTTON_3;
	buttonP->actionType		= Dlog_Action_DEFAULT;
	buttonP->visibleB		= TRUE;
	buttonP->keyEquivChar	= 0;
	
	dialogP = Show3ButtonDialog(&dialogParams);
	if (dialogP) {
		do {
			HandleOneEvent(10);
		} while (!S_insertAnswer.i_doneB);
	}
	
	return S_insertAnswer.i_itemHit >> kDriveNumShiftBits;
}
